<?php

namespace VM\AdminBundle\Controller;

use FOS\RestBundle\Controller\Annotations\View;
use VM\AdminBundle\Services\ApiGetter;
use VM\AdminBundle\Services\RDFExportGeneratorService;
use VM\AdminBundle\Services\ResetGroupService;
use VM\ApiBundle\Entity\Company;
use VM\ApiBundle\Entity\UserGroups;
use Symfony\Component\HttpFoundation\Response;

class GroupsController extends AbstractController
{
    protected $iterator = 0;

    /**
     * @View(serializerGroups={"manage"})
     */
    public function getUserGroupsAction()
    {
        return $this->getUser()->getAdminGroups();
    }



    /**
     * @View(serializerGroups={"details"})
     */
    public function saveGroupAction()
    {
        $name = $this->getRequest()->request->get('name');
        $groupId = $this->getRequest()->request->get('id');

        $ApiGetter = $this->getApiGetter();

        if(empty($groupId))
        {
            $Group = new UserGroups();
            $Group->setUser($this->getUser());
            $this->getDoctrine()->getManager()->persist($Group);
        }
        else
        {
            $Group = $ApiGetter->getGroup($groupId);
            if(!$ApiGetter->isUserGroup($this->getUser(), $Group))
            {
                throw new \Exception('Not user group');
            }
        }

        $Group->setName($name);

        $this->getDoctrine()->getManager()->flush();


        return $Group;
    }



    /**
     * @View(serializerGroups={"list"})
     */
    public function getUserGroupsApiAction()
    {
        try
        {
            $data = $this->getRequest()->request->getIterator()->getArrayCopy();

            if($this->getRequest()->getContentType() != 'json')
            {
                throw new \Exception('Wrong content-type', 30000);
            }

            if(empty($data['method']))
            {
                throw new \Exception('Wrong method', 30001);
            }

            if(empty($data['user_id']))
            {
                throw new \Exception('No user id', 30002);
            }

            if(empty($data['token']))
            {
                throw new \Exception('No user token', 30003);
            }

            $SsoCommunication = $this->getSsoCommunication();
            $response = $SsoCommunication->checkUserToken($data['user_id'], $data['token']);

            if(!empty($response['token_valid']))
            {
                $ApiGetter = $this->getApiGetter();
                $User = $ApiGetter->getUserByExternalId($data['user_id']);
            }

            switch($data['method'])
            {
                case 'getGroups':
                    $userAdminGroups = $User->getAdminGroups();
                    $groups = (!empty($userAdminGroups)) ? $userAdminGroups : array();
                    $groups[] = $User->getGroup();

                    $result = array('groups' => $groups);
                    break;
                case 'getUsers':
                    $result = $this->getGroupUsers($data);
                    break;
                default:
                    throw new \Exception('Wrong method', 30001);
                    break;
            }
            return $result;
        }
        catch(\Exception $Exception)
        {
            return array(
                'error' => array(
                    'code' => $Exception->getCode(),
                    'message' => $Exception->getMessage()
                )
            );
        }
    }


    /**
     * @View(serializerGroups={"teacherReportsList"})
     */
    public function getResultsAction()
    {
        try
        {
            $User = $this->getUser();
            return $User->getAdminGroups();
        }
        catch(\Exception $Exception)
        {
            return array(
                'error' => array(
                    'code' => $Exception->getCode(),
                    'message' => $Exception->getMessage()
                )
            );
        }
    }

    public function getRankingAction()
    {
        $startDate = new \DateTime($this->getRequest()->request->get('start_date'));
        $endDate = new \DateTime($this->getRequest()->request->get('end_date'));
        if($this->get('security.context')->isGranted('ROLE_TEACHER_CREATOR'))
        {
            $userId = 0;
        }
        else if($this->get('security.context')->isGranted('ROLE_TEACHER'))
        {
            $userId = $this->getUser()->getId();
        }
        else
        {
            return new Response(json_encode(
                array
                (
                    'error' => array
                    (
                        'message' => 'Tylko nauczyciele mogą oglądać rankingi grup.',
                        'code' => 401
                    )
                )
            ), 200);
        }
        $ranking = $this->get('vm_admin.ranking')->generateRanking($startDate, $endDate, $userId);
        return new Response(json_encode($ranking), 200);
    }

    /**
     * @View(serializerGroups={"teacherReportsList"})
     */
    public function removeGroupAction($groupId)
    {
        $this->getDoctrine()->getConnection()->beginTransaction();
        try
        {
            $Group = $this->getApiGetter()->getGroup($groupId);

            if(!$this->getUser()->getAdminGroups()->contains($Group))
            {
                throw new \Exception('Grupa nie należy do Ciebie');
            }

            $Company = $this->getApiGetter()->getGroupCompanyOrFalse($Group);
            if($Company instanceof Company)
            {
                throw new \Exception('Grupa posiada już założoną firme i nie może byc usunięta');
            }

            foreach($Group->getUsers() as $User)
            {
                if(!$User->getIsDeleted())
                {
                    throw new \Exception('Aby usunąć grupę, należy wcześniej usunąć wszystkich jej użytkowników');
                }
            }

            foreach($Group->getUsers() as $User)
            {
                $this->removeEntity($User);
            }

            foreach($Group->getRounds() as $Round)
            {
                $this->removeEntity($Round);
            }

            $this->getDoctrine()->getManager()->flush();

            $this->getDoctrine()->getManager()->remove($Group);

            $this->getDoctrine()->getManager()->flush();
            $this->getDoctrine()->getConnection()->commit();
            return true;
        }
        catch(\Exception $Exception)
        {
            $this->getDoctrine()->getConnection()->rollback();
            return array(
                'error' => array(
                    'code' => $Exception->getCode(),
                    'message' => $Exception->getMessage()
                )
            );
        }
    }


    protected function removeEntity($Entity)
    {
        $this->getDoctrine()->getManager()->remove($Entity);
    }


    /**
     * Zwraca listę osób znajdujących się w grupie, gdzie id osoby = id z SSO
     *
     * @param $data
     * @return array
     * @throws \Exception
     */
    protected function getGroupUsers($data)
    {
        if(empty($data['params']) || empty($data['params']['group_id']))
        {
            throw new \Exception('No required params: group_id', 30004);
        }

        $ApiGetter = $this->getApiGetter();
        $Group = $ApiGetter->getGroup($data['params']['group_id']);

        $users = array();

        foreach($Group->getUsers() as $User)
        {
            $users[] = array('id' => $User->getExternalId(), 'name' => $User->getName(), 'surname' => $User->getSurname());
        }

        return array('users' => $users);
    }

    /*
      * @return Response
      */
    public function getGroupFullReportAction()
    {
        $User = $this->getUser();
        $report = $this->getRequest()->get('n3data');
        $companyId = $this->getRequest()->get('company');
        $path = __DIR__ . '/../../../../web/exports/';

        //$lastRound = $this->getDoctrine()->getRepository('VM\ApiBundle\Entity\SummaryCompanyRound')->findBy(array('companyId'=>$companyId),array('roundId'=>'ASC'),1,0);
        //if(gettype($lastRound[0]) != 'object') {return new Response('NO RESPONSE');}
        $roundId = $this->getDoctrine()->getRepository('VMApiBundle:CompanyReport')->find($report['id'])->getRoundId();
        $roundIdFilename = $this->getDoctrine()->getRepository('VMApiBundle:CompanyReport')->find($report['id'])->getRound()->getSequence();
        $filename = 'raport_firmy'.$companyId.'_dla_u'.$User->getId().'_'.'runda'.$roundIdFilename.'_'.date("YmdHis").'.n3';

        $LastRoundObj = $this->getDoctrine()->getRepository('VMApiBundle:SummaryCompanyRound')->findOneBy(array('roundId'=>$roundId, 'companyId'=>$companyId));

//        $LastRoundObj = $lastRound[0];
        //$data = json_decode($LastRoundObj->getData());
        $results = json_decode($LastRoundObj->getResults());

        \EasyRdf_Namespace::set('fullReport', $this->container->getParameter('rdf_n3_namespace'));
        \EasyRdf_Namespace::set('pole', 'pole');
        $RDFGraph = new \EasyRdf_Graph();
        $Res = $RDFGraph->resource($this->container->getParameter('rdf_n3_namespace'));

        $RDFExport = new RDFExportGeneratorService($this->getDoctrine()->getManager(),$this->container->getParameter('rdf_n3_namespace'));
        //$RDFGraph = $RDFExport->objToRDF($RDFGraph,$data,$Res);
        $RDFGraph = $RDFExport->objToRDF($RDFGraph,$results,$Res);

        $exportData = $RDFGraph->serialise('turtle');

        $handle = fopen($path.$filename, "w");
        $check = fwrite($handle, $exportData);

        if($check != false)
        {
            $this->getRequest()->getSession()->set('last_generate_file_path', $path.$filename);
            $this->getRequest()->getSession()->set('last_generate_file_name', $filename);
            return new Response('OK');
        }
        else
        {
            $this->getRequest()->getSession()->set('last_generate_file_path', '');
            $this->getRequest()->getSession()->set('last_generate_file_name', '');
            return new Response('ERROR');
        }

    }


    /*
      * @return Response
      */
    public function getGroupSQLReportAction()
    {
        $User = $this->getUser();
        $report = $this->getRequest()->get('n3data');
        $companyId = $this->getRequest()->get('company');

        $path = __DIR__ . '/../../../../web/exports/';

        $roundId = $this->getDoctrine()->getRepository('VMApiBundle:CompanyReport')->find($report['id'])->getRoundId();
        $roundIdFilename = $this->getDoctrine()->getRepository('VMApiBundle:CompanyReport')->find($report['id'])->getRound()->getSequence();
        $filename = 'raport_firmy'.$companyId.'_dla_u'.$User->getId().'_'.'runda'.$roundIdFilename.'_'.date("YmdHis").'.n3';

        $exportData = $this->getDoctrine()->getRepository('VMApiBundle:RDFExport')->findOneBy(array('roundId'=>$roundId, 'companyId'=>$companyId));
        if(count($exportData) == 1)
        {
            $handle = fopen($path.$filename, "w");
            $check = fwrite($handle, $exportData->getExportData());
        }
        else {$check = false;}

        if($check != false)
        {
            $this->getRequest()->getSession()->set('last_generate_file_path', $path.$filename);
            $this->getRequest()->getSession()->set('last_generate_file_name', $filename);
            return new Response('OK');
        }
        else
        {
            $this->getRequest()->getSession()->set('last_generate_file_path', '');
            $this->getRequest()->getSession()->set('last_generate_file_name', '');
            return new Response('ERROR');
        }

    }

    /*
  * @return Response
  */
    public function getGroupEffectReportAction()
    {
        $User = $this->getUser();
        $filename = 'raport_efektywnosci_dla_u'.$User->getId().'_'.date("YmdHis").'.n3';
        $path = __DIR__ . '/../../../../web/exports/';

        $dataCollection = $this->getDoctrine()->getRepository('VMApiBundle:SummaryCompanyRound')->findLastForUser($User->getId());
        if(count($dataCollection) != 0)
        {
            $check = true;
            $results = array();
            foreach($dataCollection as $Summary)
            {
                $company = $Summary->getCompanyId();
                $results[$company]['id'] = $company;
                $results[$company]['name'] = $Summary->getCompany()->getName();
                $obj = json_decode($Summary->getResults());
                foreach($obj->RachunekZyskowIStrat->zyskNetto as $round=>$val)
                {
                    $results[$company]['netto'][$round] = $val;
                }
            }

            $config = array(
                'db_host' => $this->container->getParameter('sparql_host'),
                'db_name' => $this->container->getParameter('sparql_database'),
                'db_user' => $this->container->getParameter('sparql_user'),
                'db_pwd' => $this->container->getParameter('sparql_password'),
                'store_name' => $this->container->getParameter('sparql_prefix'),
                'bnode_prefix' => $this->container->getParameter('sparql_bn'),
                'sem_html_formats' => $this->container->getParameter('sparql_html')
            );

            $store = \ARC2::getStore($config);
            if (!$store->isSetUp()) {
                $store->setUp();
            }

            foreach($results as $id=>$data)
            {
                $store->query('INSERT INTO <'.$this->container->getParameter('rdf_n3_namespace').'> {
 "firma_'.$data['id'].'" "pole:nazwa" "'.$data['name'].'";
                }');
                $store->query('INSERT INTO <'.$this->container->getParameter('rdf_n3_namespace').'> {
 "firma_'.$data['id'].'" "pole:user" "'.$User->getId().'";
                }');
                foreach($data['netto'] as $key=>$val)
                {
                    $store->query('INSERT INTO <'.$this->container->getParameter('rdf_n3_namespace').'> {
 "firma_'.$data['id'].'" "pole:runda_'.$key.'" '.$val.';
                }');
                }
            }


//            var_dump($errs = $store->getErrors());
            $result = $store->query(
                'SELECT ?s ?p ?o WHERE {
	GRAPH ?g { ?firma ?p ?o . }
    ?firma "pole:nazwa" ?s .
    ?firma "pole:user" ?user
    FILTER regex(?p, "^pole:runda")
    FILTER regex(?user, "'.$User->getId().'")
}
ORDER BY ?p DESC(?o)'
            );

            $ser = \ARC2::getTurtleSerializer();
            $exportData = $ser->getSerializedTriples($result['result']['rows']);
        }
        else {$check = false;}

        if($check != false)
        {
            $handle = fopen($path.$filename, "w");
            $check = fwrite($handle, $exportData);
            $this->getRequest()->getSession()->set('last_generate_file_path', $path.$filename);
            $this->getRequest()->getSession()->set('last_generate_file_name', $filename);
            return new Response('OK');
        }
        else
        {
            $this->getRequest()->getSession()->set('last_generate_file_path', '');
            $this->getRequest()->getSession()->set('last_generate_file_name', '');
            return new Response('ERROR');
        }

    }

    /**
     * @View(serializerGroups={"details"})
     */
    public function resetGroupAction()
    {
        $groupId = $this->getRequest()->request->get('id');

        $ApiGetter = $this->getApiGetter();
        /** @var ResetGroupService $ResetGroupService */
        $ResetGroupService = $this->get('vm_admin.reset_group');

        try
        {
            if(empty($groupId))
            {
                throw new \Exception('Missing group_id');
            }
            else
            {
                $Group = $ApiGetter->getGroup($groupId);

                if(empty($Group))
                {
                    throw new \Exception("Brak grupy o podanym id.");
                }

                $CurrentRound = $this->getApiGetter()->getGroupActualRound($Group);

                if(empty($CurrentRound))
                {
                    throw new \Exception("Ta grupa nie rozpoczęła jeszcze gry - reset niepotrzebny.");
                }

                if($Group->getWasReset() && ($CurrentRound->getSequence() < 8))
                {
                    throw new \Exception("Reset gry dopuszczalny tylko raz.");
                }

                if($CurrentRound->getSequence() > 3 && ($CurrentRound->getSequence() != 8))
                {
                    throw new \Exception("Grupę można zresetować raz przed czwartą turą lub na koniec gry.".$CurrentRound->getSequence());
                }

                if(!$ApiGetter->isUserGroup($this->getUser(), $Group))
                {
                    throw new \Exception('Ten użytkownik nie ma dostępu do tej grupy.');
                }
                else
                {
                    $ResetGroupService->resetGroup($Group, $CurrentRound->getSequence() == 8);
                }
            }

            $this->getDoctrine()->getManager()->flush();
            $Group = $ApiGetter->getGroup($groupId);
        }
        catch(\Exception $exception)
        {
            return new Response(json_encode(array('message' => $exception->getMessage(), 'code' => 500)), 500);
        }

        return $Group;
    }
}
